/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantHistory;
import filenet.vw.api.VWStepWorkObjectHistory;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkParticipantHistory;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;

public final class VWTrkWork {
    private String m_wobNumber = null;
    private int m_stepId = -1;
    private VWTrkStepOccurrence m_occurrence = null;
    private Vector<VWTrkParticipant> m_participants = new Vector();

    public VWTrkWork(int stepId, VWTrkStepOccurrence occurrence, VWStepWorkObjectHistory workHistory) {
        this.m_stepId = stepId;
        this.m_occurrence = occurrence;
        this.m_wobNumber = workHistory.getWorkObjectNumber();
        this.setWorkHistory(workHistory);
    }

    public VWTrkWork(int stepId, VWTrkStepOccurrence occurrence, VWTrkParticipantHistory participantHistory) {
        this.m_stepId = stepId;
        this.m_occurrence = occurrence;
        this.m_wobNumber = participantHistory.getWorkObjectNumber();
        this.m_participants.addElement(new VWTrkParticipant(this, participantHistory));
    }

    public VWTrkWork(int stepId, VWTrkStepOccurrence occurrence, VWTrkWorkObject workObject) {
        this.m_stepId = stepId;
        this.m_occurrence = occurrence;
        this.m_wobNumber = workObject.getWorkObjectNumber();
        this.m_participants.addElement(new VWTrkParticipant(this, workObject));
    }

    public VWTrkStepOccurrence getStepOccurrence() {
        return this.m_occurrence;
    }

    public String getWorkObjectNumber() {
        return this.m_wobNumber;
    }

    public VWTrkWorkObject getWorkObject() {
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            return participant.getParticipantWorkObject();
        }
        return null;
    }

    public Vector getParticipants() {
        VWTrkParticipant participant;
        if (this.m_participants.size() > 1 && (participant = this.m_participants.lastElement()) != null && participant.isActive()) {
            this.m_participants.removeElement(participant);
            this.m_participants.addElement(participant);
        }
        return this.m_participants;
    }

    VWTrkParticipant findParticipant(String name, Date dateReceived) {
        if (dateReceived == null || name == null) {
            return null;
        }
        for (int i = 0; i < this.m_participants.size(); ++i) {
            VWTrkParticipant participant = this.m_participants.elementAt(i);
            if (VWStringUtils.compare(name, participant.getParticipant().getParticipantName()) != 0 || !dateReceived.equals(participant.getDateReceived())) continue;
            return participant;
        }
        return null;
    }

    VWTrkParticipant findParticipant(VWTrkParticipantHistory participantHistory) {
        if (this.m_participants == null || this.m_participants.size() == 0) {
            return null;
        }
        return this.findParticipant(participantHistory.getVWParticipantHistory());
    }

    VWTrkParticipant findParticipant(VWParticipantHistory participantHistory) {
        if (participantHistory == null || this.m_participants == null || this.m_participants.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.m_participants.size(); ++i) {
            VWParticipantHistory vwParticipantHistory;
            VWTrkParticipant participant = this.m_participants.elementAt(i);
            if (participant == null) continue;
            VWTrkParticipantHistory history = participant.getParticipantHistory();
            if (history != null && (vwParticipantHistory = history.getVWParticipantHistory()) != null) {
                if (!vwParticipantHistory.getIsSameParticipant(participantHistory)) continue;
                return participant;
            }
            try {
                VWTrkWorkObject wob = participant.getParticipantWorkObject();
                if (wob == null || !participantHistory.getIsSameParticipant(wob.getVWWorkObject())) continue;
                return participant;
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
        return null;
    }

    VWTrkParticipant findParticipant(VWTrkWorkObject workObject) {
        if (this.m_participants == null || this.m_participants.size() == 0) {
            return null;
        }
        try {
            for (int i = this.m_participants.size() - 1; i >= 0; --i) {
                VWTrkParticipant participant = this.m_participants.elementAt(i);
                if (participant != null) {
                    VWParticipantHistory vwParticipantHistory;
                    if (participant.getCompletionDate() != null) continue;
                    VWTrkParticipantHistory history = participant.getParticipantHistory();
                    if (history != null && (vwParticipantHistory = history.getVWParticipantHistory()) != null && vwParticipantHistory.getIsSameParticipant(workObject.getVWWorkObject())) {
                        return participant;
                    }
                }
                if (workObject == null || participant == null) continue;
                VWParticipant name1 = workObject.getParticipant();
                VWParticipant name2 = participant.getParticipant();
                if (name1 == null || name2 == null || VWStringUtils.compare(name1.getParticipantName(), name2.getParticipantName()) != 0) continue;
                return participant;
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public void addParticipantHistory(VWTrkParticipantHistory participantHistory) {
        if (participantHistory == null) {
            return;
        }
        if (this.m_wobNumber == null) {
            return;
        }
        if (VWStringUtils.compare(this.m_wobNumber, participantHistory.getWorkObjectNumber()) != 0) {
            return;
        }
        VWTrkParticipant participant = this.findParticipant(participantHistory);
        if (participant != null) {
            participant.updateHistory(participantHistory);
        } else {
            participant = new VWTrkParticipant(this, participantHistory);
            this.m_participants.addElement(participant);
        }
        VWTrkParticipant activeParticipant = this.getActiveParticipant();
        if (activeParticipant != null && activeParticipant != this.m_participants.lastElement()) {
            this.m_participants.removeElement(activeParticipant);
            this.m_participants.addElement(activeParticipant);
        }
    }

    public void setWorkHistory(VWStepWorkObjectHistory workHistory) {
        VWTrkParticipant participant;
        if (workHistory == null) {
            return;
        }
        if (this.m_wobNumber == null) {
            return;
        }
        if (VWStringUtils.compare(this.m_wobNumber, workHistory.getWorkObjectNumber()) != 0) {
            return;
        }
        for (int i = this.m_participants.size() - 1; i >= 0; --i) {
            participant = this.m_participants.elementAt(i);
            VWTrkParticipantHistory history = participant.getParticipantHistory();
            if (history == null || history.getVWParticipantHistory() != null || participant.getParticipantWorkObject() != null) continue;
            this.m_participants.removeElementAt(i);
        }
        try {
            while (workHistory.hasNext()) {
                VWTrkParticipant activeParticipant;
                VWParticipantHistory participantHistory = workHistory.next();
                participant = this.findParticipant(participantHistory);
                if (participant != null) {
                    participant.updateHistory(participantHistory);
                } else {
                    participant = new VWTrkParticipant(this, participantHistory);
                    this.m_participants.addElement(participant);
                }
                if ((activeParticipant = this.getActiveParticipant()) == null || activeParticipant == this.m_participants.lastElement()) continue;
                this.m_participants.removeElement(activeParticipant);
                this.m_participants.addElement(activeParticipant);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public void addParticipantHistory(VWParticipantHistory participantHistory) {
        if (participantHistory == null) {
            return;
        }
        if (this.m_wobNumber == null) {
            return;
        }
        if (VWStringUtils.compare(this.m_wobNumber, participantHistory.getWorkObjectNumber()) != 0) {
            return;
        }
        VWTrkParticipant participant = this.findParticipant(participantHistory);
        if (participant != null) {
            participant.updateHistory(participantHistory);
        } else {
            participant = new VWTrkParticipant(this, participantHistory);
            this.m_participants.addElement(participant);
        }
        VWTrkParticipant activeParticipant = this.getActiveParticipant();
        if (activeParticipant != null && activeParticipant != this.m_participants.lastElement()) {
            this.m_participants.removeElement(activeParticipant);
            this.m_participants.addElement(activeParticipant);
        }
    }

    public void addWorkObject(VWTrkWorkObject workObject) {
        if (workObject == null) {
            return;
        }
        VWTrkParticipant participant = this.findParticipant(workObject);
        if (participant != null) {
            participant.setWorkObject(workObject);
        } else {
            participant = new VWTrkParticipant(this, workObject);
            this.m_participants.addElement(participant);
        }
        VWTrkParticipant activeParticipant = this.getActiveParticipant();
        if (activeParticipant != null && activeParticipant != this.m_participants.lastElement()) {
            this.m_participants.removeElement(activeParticipant);
            this.m_participants.addElement(activeParticipant);
        }
    }

    public boolean isActive() {
        VWTrkParticipant participant = this.getActiveParticipant();
        return participant != null;
    }

    public boolean isAltered() {
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            return participant.getIsAltered();
        }
        return false;
    }

    public boolean lockWork() {
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            return participant.lockWork();
        }
        return false;
    }

    public boolean unlockWork(boolean bSave, boolean bDispatch) {
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            return participant.unlockWork(bSave, bDispatch);
        }
        return false;
    }

    public int getLockedStatus() {
        int status = 0;
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            status = participant.getLockedStatus();
        }
        return status;
    }

    public boolean isLockedByCurrentUserEntirely() {
        return 2 == this.getLockedStatus();
    }

    public boolean isLockedByCurrentUser() {
        return (2 & this.getLockedStatus()) != 0;
    }

    public int getStepId() {
        return this.m_stepId;
    }

    public Date getCompletionDate() {
        VWTrkParticipant participant = this.getFinalParticipant();
        if (participant != null) {
            return participant.getCompletionDate();
        }
        return null;
    }

    public Date getDateReceived() {
        VWTrkParticipant participant;
        if (this.m_participants != null && this.m_participants.size() > 0 && (participant = this.m_participants.elementAt(0)) != null) {
            return participant.getDateReceived();
        }
        return null;
    }

    public Date getDeadline() {
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            return participant.getDeadline();
        }
        return null;
    }

    public int getOverdue() {
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            return participant.getOverdue();
        }
        return -1;
    }

    public int getStatus() {
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant == null && this.m_participants != null) {
            participant = this.m_participants.lastElement();
        }
        if (participant != null) {
            return participant.getStatus();
        }
        return 0;
    }

    VWFieldDefinition getFieldDefinition(String name) {
        if (this.m_occurrence != null) {
            return this.m_occurrence.getFieldDefinition(name);
        }
        return null;
    }

    public Vector getParticipantHistory() {
        Vector<VWTrkParticipantHistory> history = new Vector<VWTrkParticipantHistory>();
        for (int i = 0; i < this.m_participants.size(); ++i) {
            VWTrkParticipantHistory participantHistory = this.m_participants.elementAt(i).getParticipantHistory();
            if (participantHistory == null) continue;
            history.addElement(participantHistory);
        }
        return history;
    }

    public VWTrkParticipant getFinalParticipant() {
        if (this.m_participants != null && this.m_participants.size() > 0) {
            VWTrkParticipant participant = this.getActiveParticipant();
            if (participant != null) {
                return participant;
            }
            return this.m_participants.lastElement();
        }
        return null;
    }

    public VWTrkParticipant getActiveParticipant() {
        VWTrkParticipant activeParticipant = null;
        VWTrkParticipant participant = null;
        for (int i = this.m_participants.size() - 1; i >= 0; --i) {
            participant = this.m_participants.elementAt(i);
            if (!participant.isActive()) continue;
            activeParticipant = participant;
            break;
        }
        if (activeParticipant != null) {
            if (activeParticipant != this.m_participants.lastElement()) {
                this.m_participants.removeElement(activeParticipant);
                this.m_participants.addElement(activeParticipant);
            }
            return activeParticipant;
        }
        return null;
    }

    public boolean isDataEditable() {
        if (this.isActive()) {
            int lockStatus = this.getLockedStatus();
            return lockStatus == 2;
        }
        return false;
    }

    public boolean isLockedByOther() {
        if (this.isActive()) {
            int lockStatus = this.getLockedStatus();
            return (lockStatus & 0xC) != 0;
        }
        return false;
    }

    public ImageIcon getLockedStatusIcon() {
        if (this.isActive()) {
            int lockedStatus = this.getLockedStatus();
            if ((lockedStatus & 0xC) != 0) {
                return VWImageLoader.createImageIcon("lockedByOther.gif");
            }
            if ((lockedStatus & 2) != 0) {
                return VWImageLoader.createImageIcon("lockedByUser.gif");
            }
            if ((lockedStatus & 1) != 0) {
                return VWImageLoader.createImageIcon("unlocked.gif");
            }
        }
        return null;
    }

    void removeWorkObject(boolean bSave) {
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            participant.removeWorkObject(bSave);
        }
    }

    void save() throws VWException {
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            participant.save();
        }
    }

    void disgardChanges() {
        VWTrkParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            participant.disgardChanges();
        }
    }

    public void removeReferences() {
        this.m_occurrence = null;
        if (this.m_participants != null) {
            for (int i = 0; i < this.m_participants.size(); ++i) {
                VWTrkParticipant obj = this.m_participants.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkParticipant)) continue;
                obj.removeReferences();
            }
            this.m_participants.removeAllElements();
            this.m_participants = null;
        }
    }
}

